package com.hero.objects.martialarts;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.GenericObjectDialog;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class RangedDamageClasses extends GenericObject {

    private static String xmlID = "RANGEDDC";

    public RangedDamageClasses(Element template) {
        super(template, RangedDamageClasses.xmlID);
    }

    public RangedDamageClasses(Element template, boolean parsedXML) {
        super(template);
    }

    /**
     * Always false.
     */
    @Override
    public boolean allowsOtherModifiers() {
        return false;
    }

    /**
     * always false.
     */
    @Override
    public boolean allowsOtherAdders() {
        return false;
    }

    @Override
    protected void init(Element element) {
        display = "+[LVL] Ranged Damage Class(es)";
        alias = "";
        baseCost = 0;
        levelCost = 4;
        levelValue = 1;
        minimumCost = 4;
        minimumLevel = 1;
        super.init(element);
    }

    @Override
    public String getColumn2Output() {
        String ret = getAlias();
        if (getInput() != null && getInput().trim().length() > 0) {
            ret += ":  " + getInput();
        }
        String adderString = getAdderString();
        if (adderString.trim().length() > 0) {
            ret += ":  ";
            ret += adderString;
        }
        String modifierString = getModifierString();
        if (modifierString.trim().length() > 0) {
            ret += " ";
            ret += getModifierString();
        }
        if (getEndUsage() > 0
                && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(),
                        "ENDURANCERESERVE") != null
                && GenericObject.findObjectByID(getAllAssignedModifiers(), "ENDRESERVEOREND") == null
                && !HeroDesigner.getInstance().getPrefs().useWG()) {
            if (getUseENDReserve()) {
                ret += " (uses END Reserve)";
            } else {
                ret += " (uses Personal END)";
            }
        }
        return ret;
    }

    @Override
    public Element getSaveXML() {
        Element root = getGeneralSaveXML();
        root.setName("RANGEDDC");
        return root;
    }

    @Override
    public void restoreFromSave(Element root) {
        super.restoreFromSave(root);
    }

    @Override
    public GenericDialog getDialog(boolean isNew, boolean isPower) {
        GenericDialog d = new GenericObjectDialog(this, isNew, isPower);
        d.setNameVisible(false);
        return d;
    }

}